import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define the grid size
rows, cols = 5, 4
tile_size = 1

# Create a figure and axis
fig, ax = plt.subplots(figsize=(cols * 2, rows * 2))

# Define colors for different statuses
colors = {
    'clear': 'green',
    'occupied': 'red',
    'painted': 'blue',
    'robot_white': 'white',
    'robot_black': 'black'
}

# Draw the grid of tiles
for r in range(rows):
    for c in range(cols):
        tile_id = f"tile_{r}-{c+1}"
        # Determine the status of the tile
        status = 'clear'
        if tile_id == 'tile_1-1':
            status = 'occupied'
        elif tile_id == 'tile_1-2':
            status = 'occupied'
        
        # Draw the tile
        rect = patches.Rectangle((c * tile_size, (rows - 1 - r) * tile_size), tile_size, tile_size, 
                                 linewidth=1, edgecolor='black', facecolor=colors[status])
        ax.add_patch(rect)
        
        # Add label and status text
        ax.text(c * tile_size + tile_size / 2, (rows - 1 - r) * tile_size + tile_size / 2, 
                f"{tile_id}\n{status}", color='black' if status == 'clear' else 'white',
                ha='center', va='center', fontsize=8)

# Add robots
robots = {
    'robot1': {'position': (1, 1), 'color': 'robot_white'},
    'robot2': {'position': (1, 2), 'color': 'robot_black'}
}

for robot, info in robots.items():
    r, c = info['position']
    circle = patches.Circle((c * tile_size - tile_size / 2, (rows - 1 - r) * tile_size + tile_size / 2), 
                            tile_size / 4, color=colors[info['color']])
    ax.add_patch(circle)
    ax.text(c * tile_size - tile_size / 2, (rows - 1 - r) * tile_size + tile_size / 2, 
            f"{robot}\n{info['color'].split('_')[1]}", color='black', ha='center', va='center', fontsize=8)

# Create a legend
legend_elements = [
    patches.Patch(facecolor=colors['clear'], edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=colors['occupied'], edgecolor='black', label='Occupied Tile'),
    patches.Patch(facecolor=colors['painted'], edgecolor='black', label='Painted Tile'),
    patches.Circle((0, 0), radius=tile_size / 8, color=colors['robot_white'], label='Robot holding white paint'),
    patches.Circle((0, 0), radius=tile_size / 8, color=colors['robot_black'], label='Robot holding black paint')
]

# Position the legend to avoid overlapping with the grid
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1), fontsize=8)

# Set limits and aspect
ax.set_xlim(0, cols * tile_size)
ax.set_ylim(0, rows * tile_size)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('tiles/one_shot/ini_diagram_code/attempts/attempt_23.png')
plt.show()
# VERIFICATION FAILED:
# Legend overlaps with the grid, and labels are not clearly readable.
